<?php
session_start();
if(!isset($_SESSION['username'])){
  header("Location: login.php");
  exit();
}

$host = "192.168.0.100";
$user = "yovansh1_rk";
$pass = "Ranjeet2.kmr";
$dbname = "yovansh1_rk";
$conn = new mysqli($host, $user, $pass, $dbname);
if($conn->connect_error){die("DB Error: ".$conn->connect_error);}

$username = $_SESSION['username'];
$role = $_SESSION['role'] ?? 'User';

include 'sidebar.php';

// 🔍 Base query
$query = "SELECT * FROM orders WHERE 1=1";

// 🎯 Role-based filters
if($role == 'User'){
  $query .= " AND created_by='$username'";
}
elseif($role == 'Agent'){
  $query .= " AND agent_name='$username'";
}
// Shipping, Admin, Operator — see all

$query .= " ORDER BY id DESC";
$result = $conn->query($query);
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>View Orders | Yovan CRM</title>
<meta name="viewport" content="width=device-width,initial-scale=1.0">
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
<style>
:root{--green:#56ab2f;--light:#f6fff3;}
body{font-family:'Poppins',sans-serif;background:var(--light);margin:0;}
.main-content{margin-left:250px;padding:90px 30px 30px;}
.container{
  background:#fff;border-radius:15px;padding:20px;
  box-shadow:0 4px 10px rgba(0,0,0,.1);
}
h2{text-align:center;color:var(--green);font-weight:600;margin-bottom:15px;}
table{width:100%;border-collapse:collapse;font-size:14px;}
th,td{border:1px solid #ddd;padding:8px;text-align:center;}
th{background:var(--green);color:#fff;}
tr:nth-child(even){background:#f9f9f9;}
tr:hover{background:#f1f1f1;}
.edit-btn{
  background:var(--green);color:#fff;border:none;
  border-radius:6px;padding:6px 10px;cursor:pointer;
}
.edit-btn:hover{background:#3c8c1e;}
@media(max-width:768px){
  .main-content{margin-left:0;padding:80px 15px;}
  table{font-size:12px;}
  th,td{padding:6px;}
}
</style>
</head>
<body>
<div class="main-content">
<div class="container">
<h2>📋 All Orders</h2>
<table>
  <tr>
    <th>S.No</th>
    <th>Order ID</th>
    <th>Customer Name</th>
    <th>Mobile</th>
    <th>Product</th>
    <th>Total (₹)</th>
    <th>State</th>
    <th>Pin Code</th>
    <th>User Name</th>
    <th>Agent Name</th>
    <th>AWB No</th>
    <th>Tracking Status</th>
    <th>Status</th>
    <th>Edit</th>
  </tr>

  <?php
  $i=1;
  if($result->num_rows>0){
    while($row=$result->fetch_assoc()){
      $pid = $row['product_id'];
      $pname = "";
      $p = $conn->query("SELECT product_name FROM product_list WHERE id='$pid'");
      if($p && $p->num_rows>0){ $pname = $p->fetch_assoc()['product_name']; }

      $order_status = $row['status'];
      $allow_edit = true;

      // Role-wise field control
      if($role == 'User' && $order_status == 'Done'){ $allow_edit = true; } // open but readonly inside
      if($role == 'Agent' && $order_status == 'Confirmed'){ $allow_edit = true; } // open but readonly inside
      // Shipping/Admin always true

      echo "<tr>
        <td>".$i++."</td>
        <td>#".(20000+$row['id'])."</td>
        <td>".htmlspecialchars($row['customer_name'])."</td>
        <td>".htmlspecialchars($row['phone'])."</td>
        <td>".htmlspecialchars($pname)."</td>
        <td>".htmlspecialchars($row['total'])."</td>
        <td>".htmlspecialchars($row['state'])."</td>
        <td>".htmlspecialchars($row['pincode'])."</td>
        <td>".htmlspecialchars($row['created_by'])."</td>
        <td>".htmlspecialchars($row['agent_name'])."</td>
        <td>".htmlspecialchars($row['awb_no'])."</td>
        <td>".htmlspecialchars($row['tracking_status'])."</td>
        <td>".htmlspecialchars($row['status'])."</td>
        <td><a href='edit_order.php?id={$row['id']}'><button class='edit-btn'>✏️ Edit</button></a></td>
      </tr>";
    }
  } else {
    echo "<tr><td colspan='14'>No orders found.</td></tr>";
  }
  ?>
</table>
</div>
</div>
</body>
</html>
