<?php
session_start();
if (!isset($_SESSION['username']) || $_SESSION['role'] != 'Admin') {
    header("Location: dashboard.php");
    exit();
}

$host = "192.168.0.100";
$user = "yovansh1_rk";
$pass = "Ranjeet2.kmr";
$dbname = "yovansh1_rk";
$conn = new mysqli($host, $user, $pass, $dbname);
if ($conn->connect_error) die("DB Error: " . $conn->connect_error);

// Add User
if (isset($_POST['add_user'])) {
    $username = $_POST['username'];
    $password = $_POST['password'];
    $role = $_POST['role'];
    $stmt = $conn->prepare("INSERT INTO users (username, password, role) VALUES (?, ?, ?)");
    $stmt->bind_param("sss", $username, $password, $role);
    if ($stmt->execute()) echo "<script>alert('✅ User added successfully!');</script>";
    else echo "<script>alert('❌ Error adding user');</script>";
}

// Delete User
if (isset($_GET['delete'])) {
    $id = intval($_GET['delete']);
    $conn->query("DELETE FROM users WHERE id=$id");
    echo "<script>alert('🗑️ User deleted');window.location='user_manage.php';</script>";
}

// Edit User
if (isset($_POST['edit_user'])) {
    $id = intval($_POST['id']);
    $username = $_POST['username'];
    $password = $_POST['password'];
    $role = $_POST['role'];
    $stmt = $conn->prepare("UPDATE users SET username=?, password=?, role=? WHERE id=?");
    $stmt->bind_param("sssi", $username, $password, $role, $id);
    if ($stmt->execute()) echo "<script>alert('✅ User updated!');window.location='user_manage.php';</script>";
    else echo "<script>alert('❌ Error updating user');</script>";
}

// Fetch Users
$result = $conn->query("SELECT * FROM users ORDER BY id DESC");

include 'sidebar.php';
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>User Management | Yovan CRM</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
<style>
:root {
  --green:#56ab2f;--light:#f6fff3;--border:#dce8d0;
}
body {font-family:'Poppins',sans-serif;background:var(--light);margin:0;}
.main {margin-left:250px;padding:20px;}
.container {
  background:#fff;padding:25px;border-radius:15px;
  box-shadow:0 4px 16px rgba(0,0,0,.1);max-width:1000px;margin:auto;
}
h2 {color:var(--green);text-align:center;margin-bottom:20px;}
form {
  display:grid;grid-template-columns:repeat(auto-fit,minmax(220px,1fr));
  gap:10px 20px;margin-bottom:20px;
}
input,select {
  width:100%;padding:10px;border:1px solid var(--border);
  border-radius:8px;font-size:14px;
}
button {
  background:var(--green);color:#fff;border:none;
  padding:10px 20px;border-radius:8px;cursor:pointer;transition:.3s;
}
button:hover {background:#3c8c1e;}
.table-responsive {overflow-x:auto;}
table {width:100%;border-collapse:collapse;font-size:13px;margin-top:10px;}
th,td {border:1px solid var(--border);padding:10px;text-align:center;}
th {background:var(--green);color:#fff;}
.action-btn {
  background:#2196f3;color:white;padding:5px 10px;border-radius:6px;
  text-decoration:none;margin:0 3px;font-size:12px;
}
.delete-btn {background:#dc3545;}
.action-btn:hover {opacity:.85;}
@media(max-width:768px){.main{margin-left:0;padding:15px;}form{grid-template-columns:1fr;}}
</style>
</head>
<body>
<div class="main">
<div class="container">
<h2>👥 Manage Users</h2>

<form method="POST">
  <input type="text" name="username" placeholder="Username" required>
  <input type="text" name="password" placeholder="Password" required>
  <select name="role" required>
    <option value="">Select Role</option>
    <option>Admin</option>
    <option>Agent</option>
    <option>Operator</option>
    <option>Shipping</option>
    <option>Inventory</option>
    <option>User</option>
  </select>
  <button type="submit" name="add_user">➕ Add User</button>
</form>

<div class="table-responsive">
<table>
<thead>
<tr>
 <th>ID</th>
 <th>Username</th>
 <th>Password</th>
 <th>Role</th>
 <th>Created</th>
 <th>Actions</th>
</tr>
</thead>
<tbody>
<?php while($u=$result->fetch_assoc()){ ?>
<tr>
 <form method="POST">
   <td><?=$u['id']?></td>
   <td><input name="username" value="<?=$u['username']?>"></td>
   <td><input name="password" value="<?=$u['password']?>"></td>
   <td>
     <select name="role">
       <?php
       $roles=['Admin','Agent','Operator','Shipping','Inventory','User'];
       foreach($roles as $r){$sel=($r==$u['role'])?'selected':'';echo"<option $sel>$r</option>";}
       ?>
     </select>
   </td>
   <td><?=date("d M Y",strtotime($u['created_at']??'now'))?></td>
   <td>
     <input type="hidden" name="id" value="<?=$u['id']?>">
     <button class="action-btn" name="edit_user">💾 Save</button>
     <a href="user_manage.php?delete=<?=$u['id']?>" class="action-btn delete-btn" onclick="return confirm('Delete this user?')">🗑️ Delete</a>
   </td>
 </form>
</tr>
<?php } ?>
</tbody>
</table>
</div>
</div>
</div>
</body>
</html>
