<?php
session_start();
if(!isset($_SESSION['username'])){
  header("Location: login.php");
  exit();
}

$username = ucfirst($_SESSION['username']);
$role = $_SESSION['role'] ?? 'User';
$current_page = basename($_SERVER['PHP_SELF']);
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Sidebar | Yovan CRM</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@500;600&display=swap" rel="stylesheet">
<style>
body {margin:0;font-family:'Poppins',sans-serif;}
.sidebar {
  width:250px;height:100vh;position:fixed;top:0;left:0;
  background:#56ab2f;color:#fff;display:flex;flex-direction:column;
  justify-content:space-between;padding:15px 0;transition:0.3s;z-index:2000;
}
.sidebar.hide {transform:translateX(-260px);}
.sidebar h2 {text-align:center;margin:0;font-size:20px;margin-bottom:5px;font-weight:600;}
.sidebar .welcome {text-align:center;font-size:14px;font-weight:500;color:#f1f8e9;margin-bottom:25px;}
.sidebar ul {list-style:none;padding:0;margin:0;}
.sidebar ul li {margin:10px 0;}
.sidebar ul li a {
  color:#fff;text-decoration:none;padding:10px 20px;display:block;
  font-size:15px;border-left:4px solid transparent;transition:0.3s;
}
.sidebar ul li a:hover,
.sidebar ul li a.active {background:#3c8c1e;border-left:4px solid #fff;}
.logout {text-align:center;padding:12px;margin-top:10px;}
.logout a {
  color:#fff;background:#e53935;padding:8px 18px;border-radius:8px;
  text-decoration:none;font-weight:600;
}
.logout a:hover {background:#c62828;}
.toggle-btn {
  position:fixed;top:15px;left:15px;background:#56ab2f;color:#fff;
  font-size:22px;padding:8px 12px;border:none;border-radius:6px;
  cursor:pointer;z-index:2100;transition:0.3s;
}
.toggle-btn:hover {background:#3c8c1e;}
@media(max-width:768px){
  .sidebar {transform:translateX(-260px);}
  .sidebar.show {transform:translateX(0);}
}
</style>
</head>
<body>

<!-- Toggle Button -->
<button class="toggle-btn" id="toggleBtn">☰</button>

<div class="sidebar" id="sidebar">
  <div>
    <h2>🧿 Yovan CRM</h2>
    <div class="welcome">👋 Welcome, <?=$username?> (<?=$role?>)</div>
    <ul>

      <!-- Common for All Roles -->
      <li><a href="dashboard.php" class="<?=($current_page=='dashboard.php')?'active':''?>">🏠 Dashboard</a></li>
      <li><a href="add_order.php" class="<?=($current_page=='add_order.php')?'active':''?>">➕ Add Order</a></li>
      <li><a href="view_orders.php" class="<?=($current_page=='view_orders.php')?'active':''?>">📋 View Orders</a></li>
      <li><a href="pincode_search.php?pincode=110001" class="<?=($current_page=='pincode_search.php')?'active':''?>">📍 Pincode Search</a></li>

      <!-- Admin / Operator -->
      <?php if($role == 'Admin' || $role == 'Operator'){ ?>
        <li><a href="assign_order.php" class="<?=($current_page=='assign_order.php')?'active':''?>">🧾 Assign Orders</a></li>
        <li><a href="user_manage.php" class="<?=($current_page=='user_manage.php')?'active':''?>">👥 Manage Users</a></li>
        <li><a href="product_manage.php" class="<?=($current_page=='product_manage.php')?'active':''?>">📦 Products</a></li>
        <li><a href="manage_status.php" class="<?=($current_page=='manage_status.php')?'active':''?>">⚙️ Manage Status</a></li>
        <li><a href="reports.php" class="<?=($current_page=='reports.php')?'active':''?>">📊 Reports</a></li>
      <?php } ?>

      <!-- Agent -->
      <?php if($role == 'Agent'){ ?>
        <li><a href="my_orders.php" class="<?=($current_page=='my_orders.php')?'active':''?>">📞 My Orders</a></li>
      <?php } ?>

      <!-- Shipping -->
      <?php if($role == 'Shipping'){ ?>
        <li><a href="shipping_orders.php" class="<?=($current_page=='shipping_orders.php')?'active':''?>">🚚 Shipping Orders</a></li>
      <?php } ?>

      <!-- Inventory -->
      <?php if($role == 'Inventory'){ ?>
        <li><a href="product_manage.php" class="<?=($current_page=='product_manage.php')?'active':''?>">📦 Product Stock</a></li>
      <?php } ?>

    </ul>
  </div>
  <div class="logout">
    <a href="logout.php">🚪 Logout</a>
  </div>
</div>

<script>
const toggleBtn = document.getElementById('toggleBtn');
const sidebar = document.getElementById('sidebar');
toggleBtn.addEventListener('click', ()=>{sidebar.classList.toggle('hide');});
window.addEventListener('resize', ()=>{if(window.innerWidth<=768){sidebar.classList.add('hide');}else{sidebar.classList.remove('hide');}});
</script>

</body>
</html>
