<?php
session_start();
if (!isset($_SESSION['username']) || !in_array($_SESSION['role'], ['Admin','Shipping'])) {
    header("Location: dashboard.php");
    exit();
}

$host = "192.168.0.100";
$user = "yovansh1_rk";
$pass = "Ranjeet2.kmr";
$dbname = "yovansh1_rk";
$conn = new mysqli($host, $user, $pass, $dbname);
if ($conn->connect_error) die("DB Error: " . $conn->connect_error);

// Update shipping info
if (isset($_POST['update_shipping'])) {
    $id = intval($_POST['id']);
    $awb_no = trim($_POST['awb_no']);
    $tracking_status = trim($_POST['tracking_status']);
    $status = trim($_POST['status']);

    $stmt = $conn->prepare("UPDATE orders SET awb_no=?, tracking_status=?, status=? WHERE id=?");
    $stmt->bind_param("sssi", $awb_no, $tracking_status, $status, $id);
    $stmt->execute();

    echo "<script>alert('✅ Shipping info updated successfully!');window.location='shipping_manage.php';</script>";
}

// Fetch all orders needing shipment
$result = $conn->query("SELECT o.*, p.product_name 
                        FROM orders o 
                        LEFT JOIN product_list p ON o.product_id = p.id 
                        ORDER BY o.id DESC");

include 'sidebar.php';
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Shipping Management | Yovan CRM</title>
<meta name="viewport" content="width=device-width,initial-scale=1.0">
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
<style>
:root {--green:#56ab2f;--light:#f6fff3;--border:#dce8d0;}
body {font-family:'Poppins',sans-serif;background:var(--light);margin:0;}
.main {margin-left:250px;padding:20px;}
.container {
  background:#fff;padding:25px;border-radius:15px;
  box-shadow:0 4px 16px rgba(0,0,0,.1);max-width:1200px;margin:auto;
}
h2 {color:var(--green);text-align:center;margin-bottom:20px;}
.table-responsive {overflow-x:auto;}
table {width:100%;border-collapse:collapse;font-size:13px;}
th,td {border:1px solid var(--border);padding:10px;text-align:center;}
th {background:var(--green);color:#fff;}
form {display:flex;gap:10px;justify-content:center;align-items:center;flex-wrap:wrap;}
input,select {
  padding:6px;border:1px solid var(--border);
  border-radius:6px;font-size:13px;
}
button {
  background:var(--green);color:#fff;border:none;
  padding:6px 12px;border-radius:6px;cursor:pointer;
}
button:hover {background:#3c8c1e;}
.status-badge {
  padding:4px 8px;border-radius:6px;color:white;font-size:12px;
}
.status-Confirmed {background:#28a745;}
.status-Dispatched {background:#007bff;}
.status-Delivered {background:#17a2b8;}
.status-Returned {background:#dc3545;}
.status-Pending {background:#ffc107;color:#000;}
@media(max-width:768px){.main{margin-left:0;padding:15px;}th,td{font-size:12px;padding:7px;}}
</style>
</head>
<body>
<div class="main">
<div class="container">
<h2>🚚 Shipping Management</h2>

<div class="table-responsive">
<table>
<thead>
<tr>
 <th>ID</th>
 <th>Customer</th>
 <th>Mobile</th>
 <th>Product</th>
 <th>Total ₹</th>
 <th>City</th>
 <th>State</th>
 <th>AWB No</th>
 <th>Tracking Status</th>
 <th>Current Status</th>
 <th>Update</th>
</tr>
</thead>
<tbody>
<?php while($row=$result->fetch_assoc()){ ?>
<tr>
 <td><?=$row['id']?></td>
 <td><?=htmlspecialchars($row['customer_name'])?></td>
 <td><?=$row['phone']?></td>
 <td><?=htmlspecialchars($row['product_name'])?></td>
 <td>₹<?=$row['total']?></td>
 <td><?=htmlspecialchars($row['city'])?></td>
 <td><?=htmlspecialchars($row['state'])?></td>
 <td><?=htmlspecialchars($row['awb_no'])?></td>
 <td><?=htmlspecialchars($row['tracking_status'])?></td>
 <td><span class="status-badge status-<?=str_replace(' ','',$row['status'])?>"><?=$row['status']?></span></td>
 <td>
   <form method="POST">
     <input type="hidden" name="id" value="<?=$row['id']?>">
     <input type="text" name="awb_no" value="<?=$row['awb_no']?>" placeholder="AWB No">
     <input type="text" name="tracking_status" value="<?=$row['tracking_status']?>" placeholder="Tracking Status">
     <select name="status">
       <option <?=$row['status']=='Confirmed'?'selected':''?>>Confirmed</option>
       <option <?=$row['status']=='Dispatched'?'selected':''?>>Dispatched</option>
       <option <?=$row['status']=='Delivered'?'selected':''?>>Delivered</option>
       <option <?=$row['status']=='Returned'?'selected':''?>>Returned</option>
     </select>
     <button name="update_shipping">💾 Save</button>
   </form>
 </td>
</tr>
<?php } ?>
</tbody>
</table>
</div>
</div>
</div>
</body>
</html>
