<?php
session_start();
if (!isset($_SESSION['username']) || $_SESSION['role'] != 'Admin') {
    header("Location: dashboard.php");
    exit();
}

$host = "192.168.0.100";
$user = "yovansh1_rk";
$pass = "Ranjeet2.kmr";
$dbname = "yovansh1_rk";
$conn = new mysqli($host, $user, $pass, $dbname);
if ($conn->connect_error) die("DB Error: " . $conn->connect_error);

// Add Product
if (isset($_POST['add_product'])) {
    $name = $_POST['product_name'];
    $price = $_POST['price'];
    $desc = $_POST['description'];
    $stock = $_POST['stock'];
    $status = $_POST['status'];

    $stmt = $conn->prepare("INSERT INTO product_list (product_name, price, description, stock, status) VALUES (?, ?, ?, ?, ?)");
    $stmt->bind_param("sisis", $name, $price, $desc, $stock, $status);
    if ($stmt->execute()) echo "<script>alert('✅ Product added successfully!');</script>";
    else echo "<script>alert('❌ Error adding product');</script>";
}

// Edit Product
if (isset($_POST['edit_product'])) {
    $id = $_POST['id'];
    $name = $_POST['product_name'];
    $price = $_POST['price'];
    $desc = $_POST['description'];
    $stock = $_POST['stock'];
    $status = $_POST['status'];

    $stmt = $conn->prepare("UPDATE product_list SET product_name=?, price=?, description=?, stock=?, status=? WHERE id=?");
    $stmt->bind_param("sisi si", $name, $price, $desc, $stock, $status, $id);
    $stmt->execute();
    echo "<script>alert('✅ Product updated!');window.location='product_manage.php';</script>";
}

// Delete Product
if (isset($_GET['delete'])) {
    $id = intval($_GET['delete']);
    $conn->query("DELETE FROM product_list WHERE id=$id");
    echo "<script>alert('🗑️ Product deleted!');window.location='product_manage.php';</script>";
}

// Fetch Products
$result = $conn->query("SELECT * FROM product_list ORDER BY id DESC");

include 'sidebar.php';
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Product Management | Yovan CRM</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
<style>
:root {--green:#56ab2f;--light:#f6fff3;--border:#dce8d0;}
body {font-family:'Poppins',sans-serif;background:var(--light);margin:0;}
.main {margin-left:250px;padding:20px;}
.container {
  background:#fff;padding:25px;border-radius:15px;
  box-shadow:0 4px 16px rgba(0,0,0,.1);max-width:1100px;margin:auto;
}
h2 {color:var(--green);text-align:center;margin-bottom:20px;}
form {
  display:grid;grid-template-columns:repeat(auto-fit,minmax(200px,1fr));
  gap:15px;margin-bottom:20px;
}
input,select,textarea {
  width:100%;padding:10px;border:1px solid var(--border);
  border-radius:8px;font-size:14px;
}
textarea {grid-column:span 2;resize:vertical;}
button {
  background:var(--green);color:#fff;border:none;
  padding:10px 20px;border-radius:8px;cursor:pointer;transition:.3s;
}
button:hover {background:#3c8c1e;}
.table-responsive {overflow-x:auto;}
table {width:100%;border-collapse:collapse;font-size:13px;margin-top:10px;}
th,td {border:1px solid var(--border);padding:10px;text-align:center;}
th {background:var(--green);color:#fff;}
.action-btn {
  background:#2196f3;color:#fff;padding:5px 10px;border-radius:6px;
  text-decoration:none;font-size:12px;margin:0 3px;display:inline-block;
}
.delete-btn {background:#dc3545;}
.action-btn:hover {opacity:.85;}
@media(max-width:768px){.main{margin-left:0;padding:15px;}form{grid-template-columns:1fr;}}
</style>
</head>
<body>
<div class="main">
<div class="container">
<h2>📦 Manage Products</h2>

<form method="POST">
  <input type="text" name="product_name" placeholder="Product Name" required>
  <input type="number" name="price" placeholder="Price (₹)" required>
  <input type="number" name="stock" placeholder="Stock Qty" required>
  <select name="status" required>
    <option value="">Select Status</option>
    <option>Active</option>
    <option>Inactive</option>
  </select>
  <textarea name="description" placeholder="Description"></textarea>
  <button name="add_product">➕ Add Product</button>
</form>

<div class="table-responsive">
<table>
<thead>
<tr>
 <th>ID</th>
 <th>Product Name</th>
 <th>Price (₹)</th>
 <th>Stock</th>
 <th>Status</th>
 <th>Description</th>
 <th>Created</th>
 <th>Actions</th>
</tr>
</thead>
<tbody>
<?php while($p=$result->fetch_assoc()){ ?>
<tr>
 <form method="POST">
   <td><?=$p['id']?></td>
   <td><input name="product_name" value="<?=$p['product_name']?>"></td>
   <td><input name="price" value="<?=$p['price']?>"></td>
   <td><input name="stock" value="<?=$p['stock']?>"></td>
   <td>
     <select name="status">
       <option <?=$p['status']=='Active'?'selected':''?>>Active</option>
       <option <?=$p['status']=='Inactive'?'selected':''?>>Inactive</option>
     </select>
   </td>
   <td><textarea name="description"><?=$p['description']?></textarea></td>
   <td><?=date("d M Y",strtotime($p['created_at']))?></td>
   <td>
     <input type="hidden" name="id" value="<?=$p['id']?>">
     <button class="action-btn" name="edit_product">💾 Save</button>
     <a href="product_manage.php?delete=<?=$p['id']?>" class="action-btn delete-btn" onclick="return confirm('Delete this product?')">🗑️ Delete</a>
   </td>
 </form>
</tr>
<?php } ?>
</tbody>
</table>
</div>
</div>
</div>
</body>
</html>
