<?php
session_start();
if(!isset($_SESSION['username'])){
  header("Location: login.php");
  exit();
}

$pincode = $_GET['pincode'] ?? '110001';
include 'sidebar.php';
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Pincode Search | Yovan CRM</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
<style>
:root {--green:#56ab2f;--light:#f6fff3;}
body {font-family:'Poppins',sans-serif;background:var(--light);margin:0;}
.main-content {
  margin-left:250px;
  padding:90px 25px 25px;
}
.container {
  background:#fff;
  border-radius:15px;
  box-shadow:0 4px 16px rgba(0,0,0,0.1);
  padding:20px;
  text-align:center;
}
h2 {
  color:var(--green);
  font-weight:600;
  margin-bottom:15px;
}
iframe {
  width:100%;
  height:80vh;
  border:none;
  border-radius:12px;
  box-shadow:0 0 10px rgba(0,0,0,0.1);
}
.input-box {
  display:flex;
  justify-content:center;
  align-items:center;
  gap:10px;
  margin-bottom:15px;
}
.input-box input {
  width:150px;
  padding:6px 10px;
  border:1px solid #ccc;
  border-radius:8px;
  font-size:14px;
}
.input-box button {
  background:var(--green);
  color:#fff;
  border:none;
  border-radius:8px;
  padding:7px 15px;
  cursor:pointer;
  font-weight:600;
}
.input-box button:hover {background:#3c8c1e;}
@media(max-width:768px){
  .main-content{margin-left:0;padding:80px 10px;}
  iframe{height:70vh;}
}
</style>
</head>
<body>
<div class="main-content">
  <div class="container">
    <h2>📍 Pincode Search</h2>
    <div class="input-box">
      <form method="GET">
        <input type="text" name="pincode" value="<?=htmlspecialchars($pincode)?>" maxlength="6" placeholder="Enter PIN code" required>
        <button type="submit">🔍 Search</button>
      </form>
    </div>

    <iframe src="https://www.pincode.net.in/<?=htmlspecialchars($pincode)?>" title="Pincode Info"></iframe>
  </div>
</div>
</body>
</html>
