<?php
session_start();
if (!isset($_SESSION['username']) || !in_array($_SESSION['role'], ['Admin','Inventory'])) {
    header("Location: dashboard.php");
    exit();
}

$host = "192.168.0.100";
$user = "yovansh1_rk";
$pass = "Ranjeet2.kmr";
$dbname = "yovansh1_rk";
$conn = new mysqli($host, $user, $pass, $dbname);
if ($conn->connect_error) die("DB Error: " . $conn->connect_error);

// Update stock
if (isset($_POST['update_stock'])) {
    $id = intval($_POST['id']);
    $qty = intval($_POST['quantity']);
    $action = $_POST['action_type'];

    $current = $conn->query("SELECT stock FROM product_list WHERE id=$id")->fetch_assoc()['stock'];
    $new_stock = ($action == 'add') ? ($current + $qty) : max(0, $current - $qty);

    $stmt = $conn->prepare("UPDATE product_list SET stock=? WHERE id=?");
    $stmt->bind_param("ii", $new_stock, $id);
    $stmt->execute();

    echo "<script>alert('✅ Stock updated successfully!');window.location='inventory_stock.php';</script>";
}

$result = $conn->query("SELECT * FROM product_list ORDER BY product_name ASC");
include 'sidebar.php';
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Inventory Stock | Yovan CRM</title>
<meta name="viewport" content="width=device-width,initial-scale=1">
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
<style>
:root {--green:#56ab2f;--light:#f6fff3;--border:#dce8d0;}
body {font-family:'Poppins',sans-serif;background:var(--light);margin:0;}
.main {margin-left:250px;padding:20px;}
.container {
  background:#fff;padding:25px;border-radius:15px;
  box-shadow:0 4px 16px rgba(0,0,0,.1);max-width:1100px;margin:auto;
}
h2 {color:var(--green);text-align:center;margin-bottom:20px;}
.table-responsive {overflow-x:auto;}
table {width:100%;border-collapse:collapse;font-size:13px;}
th,td {border:1px solid var(--border);padding:10px;text-align:center;}
th {background:var(--green);color:#fff;}
form {display:flex;gap:10px;justify-content:center;align-items:center;flex-wrap:wrap;}
input[type=number] {
  width:80px;padding:6px;border:1px solid var(--border);
  border-radius:6px;text-align:center;
}
select {
  padding:6px;border-radius:6px;border:1px solid var(--border);
}
button {
  background:var(--green);color:#fff;border:none;
  padding:6px 12px;border-radius:6px;cursor:pointer;font-size:13px;
}
button:hover {background:#3c8c1e;}
.status-active {color:#28a745;font-weight:600;}
.status-inactive {color:#dc3545;font-weight:600;}
@media(max-width:768px){.main{margin-left:0;padding:15px;}th,td{font-size:12px;padding:7px;}}
</style>
</head>
<body>
<div class="main">
<div class="container">
<h2>🏗️ Inventory Stock Management</h2>

<div class="table-responsive">
<table>
<thead>
<tr>
 <th>ID</th>
 <th>Product Name</th>
 <th>Price (₹)</th>
 <th>Description</th>
 <th>Stock</th>
 <th>Status</th>
 <th>Update Stock</th>
</tr>
</thead>
<tbody>
<?php while($p=$result->fetch_assoc()){ ?>
<tr>
 <td><?=$p['id']?></td>
 <td><?=htmlspecialchars($p['product_name'])?></td>
 <td><?=$p['price']?></td>
 <td><?=htmlspecialchars($p['description'])?></td>
 <td><b><?=$p['stock']?></b></td>
 <td>
   <?php if($p['status']=='Active'){ ?>
     <span class="status-active">Active</span>
   <?php } else { ?>
     <span class="status-inactive">Inactive</span>
   <?php } ?>
 </td>
 <td>
   <form method="POST">
     <input type="hidden" name="id" value="<?=$p['id']?>">
     <input type="number" name="quantity" min="1" required>
     <select name="action_type">
       <option value="add">➕ Add</option>
       <option value="remove">➖ Remove</option>
     </select>
     <button name="update_stock">Update</button>
   </form>
 </td>
</tr>
<?php } ?>
</tbody>
</table>
</div>
</div>
</div>
</body>
</html>
