<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
$username = $_SESSION['username'] ?? '';
$role = $_SESSION['role'] ?? '';
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width,initial-scale=1.0">
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
<style>
:root{
  --green:#56ab2f;
  --darkgreen:#3c8c1e;
  --light:#f6fff3;
  --border:#dce8d0;
}
body{margin:0;font-family:'Poppins',sans-serif;}
.topbar{
  background:#fff;
  position:fixed;
  top:0;left:250px;
  right:0;
  height:60px;
  display:flex;
  align-items:center;
  justify-content:space-between;
  padding:0 20px;
  border-bottom:1px solid var(--border);
  box-shadow:0 2px 8px rgba(0,0,0,.05);
  z-index:900;
  transition:.3s;
}
.topbar-left{
  font-weight:600;
  color:var(--green);
  font-size:16px;
}
.topbar-right{
  display:flex;
  align-items:center;
  gap:15px;
}
.time{
  font-size:14px;
  color:#555;
}
.profile{
  position:relative;
}
.profile button{
  background:var(--green);
  color:#fff;
  border:none;
  border-radius:8px;
  padding:6px 12px;
  cursor:pointer;
  font-weight:600;
}
.dropdown{
  display:none;
  position:absolute;
  right:0;
  top:40px;
  background:#fff;
  border-radius:10px;
  box-shadow:0 4px 10px rgba(0,0,0,.1);
  overflow:hidden;
  min-width:140px;
}
.dropdown a{
  display:block;
  padding:10px;
  text-decoration:none;
  color:#333;
  font-size:14px;
  border-bottom:1px solid #eee;
}
.dropdown a:hover{background:#f6fff3;color:var(--green);}
@media(max-width:768px){
  .topbar{left:0;}
}
</style>
<script>
function toggleProfile(){
  const d=document.getElementById('profileDropdown');
  d.style.display=(d.style.display==='block')?'none':'block';
}
function updateTime(){
  const t=new Date();
  const h=t.getHours();
  const greeting=(h<12)?'🌅 Good Morning':
                   (h<18)?'☀️ Good Afternoon':'🌙 Good Evening';
  document.getElementById('greet').innerText=greeting + " <?=ucfirst($username)?> 👋";
  document.getElementById('time').innerText=t.toLocaleString();
}
setInterval(updateTime,1000);
window.onload=updateTime;
</script>
</head>
<body>
<div class="topbar">
  <div class="topbar-left" id="greet">Welcome 👋</div>
  <div class="topbar-right">
    <div class="time" id="time"></div>
    <div class="profile">
      <button onclick="toggleProfile()">👤 <?=ucfirst($username)?></button>
      <div class="dropdown" id="profileDropdown">
        <a href="dashboard.php">🏠 Dashboard</a>
        <a href="user_manage.php">⚙️ Settings</a>
        <a href="logout.php">🚪 Logout</a>
      </div>
    </div>
  </div>
</div>
</body>
</html>
