<?php
session_start();
if(!isset($_SESSION['username'])){
  header("Location: login.php");
  exit();
}

$host = "192.168.0.100";
$user = "yovansh1_rk";
$pass = "Ranjeet2.kmr";
$dbname = "yovansh1_rk";
$conn = new mysqli($host, $user, $pass, $dbname);
if($conn->connect_error){die("DB Error: ".$conn->connect_error);}

$username = $_SESSION['username'];
$role = $_SESSION['role'] ?? 'User';
$order_id = $_GET['id'] ?? 0;

include 'sidebar.php';

// Fetch order data
$stmt = $conn->prepare("SELECT * FROM orders WHERE id=?");
$stmt->bind_param("i", $order_id);
$stmt->execute();
$order = $stmt->get_result()->fetch_assoc();
if(!$order){die("<script>alert('Order not found!');window.location='view_orders.php';</script>");}

// Product list
$products = $conn->query("SELECT id, product_name FROM product_list WHERE status='Active'");

// 🔹 Status logic
if($role == 'Admin' || $role == 'Operator'){
  $statusList = $conn->query("SELECT name FROM order_status WHERE status='Active'");
} else {
  // Only Pending & Done for Users
  $statusList = $conn->query("SELECT name FROM order_status WHERE name IN ('Pending','Done') AND status='Active'");
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Edit Order | Yovan CRM</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
<style>
:root{--green:#56ab2f;--light:#f6fff3;}
body{font-family:'Poppins',sans-serif;background:var(--light);margin:0;}
.main-content{margin-left:250px;padding:90px 30px 30px;}
form{
  background:#fff;border-radius:15px;padding:25px;
  box-shadow:0 4px 10px rgba(0,0,0,.1);max-width:800px;margin:auto;
}
h2{text-align:center;color:var(--green);margin-bottom:20px;}
label{font-weight:500;display:block;margin-top:10px;}
input,select,textarea{
  width:100%;padding:8px;border:1px solid #ccc;border-radius:8px;
  margin-top:5px;font-family:'Poppins';
}
.row{display:flex;gap:15px;}
.row>div{flex:1;}
.btn{
  background:var(--green);color:#fff;border:none;padding:10px 18px;
  border-radius:8px;cursor:pointer;font-weight:600;margin-top:20px;
}
.btn:hover{background:#3c8c1e;}
@media(max-width:768px){.main-content{margin-left:0;padding:80px 15px;}.row{flex-direction:column;}}
</style>
</head>
<body>
<div class="main-content">
<form method="POST" action="update_order.php">
<h2>📝 Edit Order</h2>
<input type="hidden" name="id" value="<?=$order['id']?>">

<div class="row">
  <div>
    <label>Customer Name</label>
    <input type="text" name="customer_name" value="<?=$order['customer_name']?>" required>
  </div>
  <div>
    <label>Mobile</label>
    <input type="text" name="phone" value="<?=$order['phone']?>" required>
  </div>
</div>

<label>Address</label>
<textarea name="address" rows="2"><?=$order['address']?></textarea>

<div class="row">
  <div><label>State</label><input type="text" name="state" value="<?=$order['state']?>"></div>
  <div><label>City</label><input type="text" name="city" value="<?=$order['city']?>"></div>
  <div><label>Pincode</label><input type="text" name="pincode" value="<?=$order['pincode']?>"></div>
</div>

<div class="row">
  <div>
    <label>Product</label>
    <select name="product_id" required>
      <?php while($p=$products->fetch_assoc()){ ?>
        <option value="<?=$p['id']?>" <?=$p['id']==$order['product_id']?'selected':''?>><?=$p['product_name']?></option>
      <?php } ?>
    </select>
  </div>
  <div><label>Price</label><input type="number" step="0.01" name="price" value="<?=$order['price']?>"></div>
  <div><label>Discount</label><input type="number" step="0.01" name="discount" value="<?=$order['discount']?>"></div>
  <div><label>Advance</label><input type="number" step="0.01" name="advance" value="<?=$order['advance']?>"></div>
  <div><label>Total</label><input type="number" step="0.01" name="total" value="<?=$order['total']?>"></div>
</div>

<label>Remark</label>
<textarea name="remark" rows="2"><?=$order['remark']?></textarea>

<label>Status</label>
<select name="status" required>
  <?php while($s=$statusList->fetch_assoc()){ ?>
    <option value="<?=$s['name']?>" <?=$order['status']==$s['name']?'selected':''?>><?=$s['name']?></option>
  <?php } ?>
</select>

<div style="text-align:center;">
  <button type="submit" class="btn">💾 Update Order</button>
</div>
</form>
</div>
</body>
</html>
