<?php
session_start();
if(!isset($_SESSION['username'])){
  header("Location: login.php");
  exit();
}

$host = "192.168.0.100";
$user = "yovansh1_rk";
$pass = "Ranjeet2.kmr";
$dbname = "yovansh1_rk";
$conn = new mysqli($host, $user, $pass, $dbname);
if($conn->connect_error){die("DB Error: ".$conn->connect_error);}

$username = $_SESSION['username'];
$role = $_SESSION['role'] ?? 'User';

if($role != 'Admin' && $role != 'Operator'){
  die("<script>alert('⛔ Access Denied! Only Admin/Operator can assign orders.');window.location='dashboard.php';</script>");
}

include 'sidebar.php';

// Unassigned orders
$unassigned = $conn->query("SELECT id, customer_name, phone, product_id, total, state, city, pincode, status FROM orders WHERE agent_name='' OR agent_name IS NULL ORDER BY id DESC");

// Already assigned orders
$assigned = $conn->query("SELECT id, customer_name, phone, product_id, total, state, city, pincode, status, agent_name FROM orders WHERE agent_name!='' ORDER BY id DESC");

// Active agents
$agents = $conn->query("SELECT username FROM users WHERE role='Agent' AND status='Active'");
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Assign Orders | Yovan CRM</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
<style>
:root {--green:#56ab2f;--light:#f6fff3;}
body{font-family:'Poppins',sans-serif;background:var(--light);margin:0;}
.main-content{margin-left:250px;padding:90px 30px 30px;}
.container{background:#fff;border-radius:15px;padding:20px;box-shadow:0 4px 10px rgba(0,0,0,.1);}
h2{text-align:center;color:var(--green);font-weight:600;margin-bottom:20px;}
h3{color:#333;text-align:left;margin:20px 0 10px;}
table{width:100%;border-collapse:collapse;font-size:14px;}
th,td{border:1px solid #ddd;padding:8px;text-align:center;}
th{background:var(--green);color:#fff;}
tr:nth-child(even){background:#f9f9f9;}
tr:hover{background:#f1f1f1;}
select{padding:5px;border-radius:6px;border:1px solid #ccc;}
.assign-btn{
  background:var(--green);color:#fff;border:none;padding:8px 15px;
  border-radius:6px;cursor:pointer;font-weight:600;
}
.assign-btn:hover{background:#3c8c1e;}
.bulk-section{margin-bottom:15px;text-align:center;}
.bulk-section select{font-size:15px;padding:6px 10px;margin-right:10px;}
.bulk-section .assign-btn{font-size:15px;}
.tab-box{margin-top:40px;}
@media(max-width:768px){
  .main-content{margin-left:0;padding:80px 15px;}
  table{font-size:12px;}
  th,td{padding:6px;}
}
</style>
</head>
<body>
<div class="main-content">
<div class="container">

<h2>🧾 Assign Orders to Agents</h2>

<!-- 🔹 Bulk Assign Section -->
<form method="POST" action="assign_order_action.php">
<div class="bulk-section">
  <select name="agent_name" required>
    <option value="">-- Select Agent to Assign --</option>
    <?php
      $agents->data_seek(0);
      while($a=$agents->fetch_assoc()){
        echo "<option value='".$a['username']."'>".$a['username']."</option>";
      }
    ?>
  </select>
  <button type="submit" class="assign-btn">🚀 Assign Selected Orders</button>
</div>

<table>
<tr>
  <th><input type="checkbox" id="selectAll"></th>
  <th>S.No</th>
  <th>Order ID</th>
  <th>Customer</th>
  <th>Mobile</th>
  <th>Product</th>
  <th>Total ₹</th>
  <th>State</th>
  <th>City</th>
  <th>Status</th>
</tr>

<?php
$i=1;
if($unassigned->num_rows>0){
  while($row=$unassigned->fetch_assoc()){
    $pid = $row['product_id'];
    $pname = "";
    $p = $conn->query("SELECT product_name FROM product_list WHERE id='$pid'");
    if($p && $p->num_rows>0){$pname = $p->fetch_assoc()['product_name'];}

    echo "<tr>
      <td><input type='checkbox' name='order_ids[]' value='".$row['id']."'></td>
      <td>".$i++."</td>
      <td>#".(20000+$row['id'])."</td>
      <td>".htmlspecialchars($row['customer_name'])."</td>
      <td>".htmlspecialchars($row['phone'])."</td>
      <td>".htmlspecialchars($pname)."</td>
      <td>".htmlspecialchars($row['total'])."</td>
      <td>".htmlspecialchars($row['state'])."</td>
      <td>".htmlspecialchars($row['city'])."</td>
      <td>".htmlspecialchars($row['status'])."</td>
    </tr>";
  }
}else{
  echo "<tr><td colspan='10'>🎉 All orders are already assigned!</td></tr>";
}
?>
</table>
</form>

<!-- 🔸 Assigned Orders Tab -->
<div class="tab-box">
<h3>📦 Already Assigned Orders</h3>
<table>
<tr>
  <th>S.No</th>
  <th>Order ID</th>
  <th>Customer</th>
  <th>Mobile</th>
  <th>Product</th>
  <th>Total ₹</th>
  <th>State</th>
  <th>City</th>
  <th>Assigned To</th>
  <th>Status</th>
  <th>Reassign</th>
</tr>

<?php
$j=1;
if($assigned->num_rows>0){
  while($row=$assigned->fetch_assoc()){
    $pid = $row['product_id'];
    $pname = "";
    $p = $conn->query("SELECT product_name FROM product_list WHERE id='$pid'");
    if($p && $p->num_rows>0){$pname = $p->fetch_assoc()['product_name'];}

    echo "<tr>
      <td>".$j++."</td>
      <td>#".(20000+$row['id'])."</td>
      <td>".htmlspecialchars($row['customer_name'])."</td>
      <td>".htmlspecialchars($row['phone'])."</td>
      <td>".htmlspecialchars($pname)."</td>
      <td>".htmlspecialchars($row['total'])."</td>
      <td>".htmlspecialchars($row['state'])."</td>
      <td>".htmlspecialchars($row['city'])."</td>
      <td>".htmlspecialchars($row['agent_name'])."</td>
      <td>".htmlspecialchars($row['status'])."</td>
      <td>
        <form method='POST' action='assign_order_action.php' style='margin:0;'>
          <input type='hidden' name='order_ids[]' value='".$row['id']."'>
          <select name='agent_name' required>
            <option value=''>Select</option>";
            $agents->data_seek(0);
            while($a=$agents->fetch_assoc()){
              echo "<option value='".$a['username']."'>".$a['username']."</option>";
            }
          echo "</select>
          <button type='submit' class='assign-btn'>Reassign</button>
        </form>
      </td>
    </tr>";
  }
}else{
  echo "<tr><td colspan='11'>No assigned orders yet.</td></tr>";
}
?>
</table>
</div>

</div>
</div>

<script>
document.getElementById('selectAll').addEventListener('change', function(){
  const checkboxes = document.querySelectorAll('input[name="order_ids[]"]');
  checkboxes.forEach(cb => cb.checked = this.checked);
});
</script>
</body>
</html>
