<?php
session_start();
if(!isset($_SESSION['username'])){
  header("Location: login.php");
  exit();
}

$host = "192.168.0.100";
$user = "yovansh1_rk";
$pass = "Ranjeet2.kmr";
$dbname = "yovansh1_rk";
$conn = new mysqli($host, $user, $pass, $dbname);
if($conn->connect_error){die("DB Error: ".$conn->connect_error);}

$username = $_SESSION['username'];
$role = $_SESSION['role'] ?? 'User';

// Product list
$products = $conn->query("SELECT id, product_name, price FROM product_list WHERE status='Active'");

// Status list logic (only Pending/Done for normal users)
if($role == 'Admin' || $role == 'Operator' || $role == 'Agent'){
  $statuses = $conn->query("SELECT name FROM order_status ORDER BY id ASC");
}else{
  $statuses = $conn->query("SELECT name FROM order_status WHERE name IN ('Pending','Done')");
}

// Form submit
if(isset($_POST['save'])){
  $stmt = $conn->prepare("INSERT INTO orders (customer_name, phone, address, state, city, area, pincode, product_id, price, discount, advance, total, remark, status, created_by) 
                          VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
  $stmt->bind_param("sssssssiddiisss",
    $_POST['name'], $_POST['mobile'], $_POST['address'], $_POST['state'], $_POST['city'], $_POST['area'], $_POST['pincode'],
    $_POST['product_id'], $_POST['price'], $_POST['discount'], $_POST['advance'], $_POST['total'], $_POST['remark'], $_POST['status'], $username
  );

  if($stmt->execute()){
    echo "<script>alert('✅ Order Added Successfully!');window.location='view_orders.php';</script>";
  }else{
    echo "<script>alert('❌ Error Adding Order!');</script>";
  }
}

include 'sidebar.php';
include 'header.php';
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Add Order | Yovan CRM</title>
<meta name="viewport" content="width=device-width,initial-scale=1.0">
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
<style>
:root {--green:#56ab2f;--light:#f6fff3;--border:#dce8d0;}
body {font-family:'Poppins',sans-serif;background:var(--light);margin:0;}
.main-content {margin-left:250px;padding:90px 30px 30px;}
.container {
  background:#fff;width:100%;max-width:950px;border-radius:18px;
  box-shadow:0 4px 14px rgba(0,0,0,.08);padding:35px;margin:auto;
}
h2 {text-align:center;color:var(--green);margin-bottom:25px;font-weight:600;}
.row {display:flex;flex-wrap:wrap;gap:18px;margin-bottom:18px;}
.col {flex:1;min-width:150px;}
label {font-weight:600;font-size:13px;margin-bottom:6px;display:block;color:#333;}
input,select,textarea {
  width:100%;padding:8px 10px;border:1px solid var(--border);
  border-radius:8px;font-size:13px;transition:.3s;background:#fafafa;
}
input:focus,select:focus,textarea:focus {
  border-color:var(--green);box-shadow:0 0 0 2px rgba(86,171,47,.2);outline:none;background:#fff;
}
textarea {min-height:80px;resize:vertical;}
button {
  border:none;border-radius:8px;padding:10px 25px;font-size:14px;
  cursor:pointer;font-weight:600;transition:.3s;
}
.save-btn {background:var(--green);color:#fff;}
.save-btn:hover {background:#3c8c1e;}
.reset-btn {background:#ccc;color:#333;margin-left:10px;}
.reset-btn:hover {background:#aaa;color:#fff;}
#mobile-warning {color:#e53935;font-weight:600;font-size:13px;display:none;margin-top:4px;text-align:left;}
/* Popup */
.popup {
  display:none;position:fixed;top:0;left:0;width:100%;height:100%;
  backdrop-filter:blur(5px);background:rgba(0,0,0,0.35);
  justify-content:center;align-items:center;z-index:2000;
}
.popup-content {
  background:#fff;padding:25px;border-radius:15px;width:90%;max-width:650px;
  box-shadow:0 6px 20px rgba(0,0,0,.3);position:relative;
}
.popup-content h3{text-align:center;color:var(--green);margin-bottom:15px;}
.popup-content table{width:100%;border-collapse:collapse;margin-top:10px;}
.popup-content th, .popup-content td{border:1px solid #ddd;padding:8px;text-align:center;font-size:13px;}
.popup-content th{background:var(--green);color:#fff;}
.close-btn{background:#e53935;color:#fff;padding:6px 12px;border:none;border-radius:6px;cursor:pointer;position:absolute;top:10px;right:10px;}
.view-btn{background:var(--green);color:#fff;border:none;border-radius:8px;padding:7px 15px;margin-top:15px;cursor:pointer;display:block;margin-left:auto;margin-right:auto;}
.view-btn:hover{background:#3c8c1e;}
@media(max-width:768px){.main-content{margin-left:0;padding:80px 15px;}.row{flex-direction:column;gap:10px;}}
</style>

<script>
function calcTotal(){
 let p=+document.getElementById('price').value||0,
     d=+document.getElementById('discount').value||0,
     a=+document.getElementById('advance').value||0;
 document.getElementById('total').value=Math.max(p-d-a,0).toFixed(2);
}
function setPrice(){
 const opt=document.getElementById('product_id').selectedOptions[0];
 const pr=opt?opt.dataset.price:0;
 document.getElementById('price').value=pr;
 calcTotal();
}

// Duplicate mobile check
function checkMobile(){
 let mobile = document.getElementById('mobile').value;
 let warn = document.getElementById('mobile-warning');
 if(mobile.length===10){
   fetch('check_mobile.php?mobile='+mobile)
   .then(res=>res.text())
   .then(html=>{
     if(html.includes('exists')){
       warn.style.display='block';
       warn.innerText='⚠️ This mobile number already exists!';
       document.getElementById('popup').style.display='flex';
       document.getElementById('popup-data').innerHTML=html;
     } else {
       warn.style.display='none';
       document.getElementById('popup').style.display='none';
     }
   });
 } else {
   warn.style.display='none';
   document.getElementById('popup').style.display='none';
 }
}
function closePopup(){document.getElementById('popup').style.display='none';}

// Auto Pincode Fill
function getPincodeDetails(){
  const pin = document.getElementById('pincode').value;
  const areaInput = document.getElementById('area');
  if(pin.length === 6){
    fetch(`https://api.postalpincode.in/pincode/${pin}`)
    .then(res => res.json())
    .then(data => {
      if(data[0].Status === "Success"){
        const offices = data[0].PostOffice;
        document.getElementById('state').value = offices[0].State;
        document.getElementById('city').value = offices[0].District;
        if(offices.length > 0){
          areaInput.value = offices[0].Name;
        }
      } else { clearPincodeFields(); alert('⚠️ Invalid PIN Code!'); }
    })
    .catch(()=>{clearPincodeFields(); alert('❌ Unable to fetch details.');});
  } else if(pin.length < 6){clearPincodeFields();}
}
function clearPincodeFields(){
  document.getElementById('state').value='';document.getElementById('city').value='';document.getElementById('area').value='';
}
</script>
</head>
<body>
<div class="main-content">
<div class="container">
<h2>➕ Add New Order</h2>
<form method="POST">

  <!-- Name + Mobile -->
  <div class="row">
    <div class="col">
      <label>Customer Name</label>
      <input type="text" name="name" required>
    </div>
    <div class="col">
      <label>Mobile Number</label>
      <input type="text" name="mobile" id="mobile" maxlength="10" onkeyup="checkMobile()" required>
      <div id="mobile-warning"></div>
    </div>
  </div>

  <!-- Address -->
  <div class="row">
    <div class="col" style="flex:100%;">
      <label>Address</label>
      <textarea name="address"></textarea>
    </div>
  </div>

  <!-- State, City, Area, Pincode -->
  <div class="row">
    <div class="col"><label>State</label><input type="text" name="state" id="state"></div>
    <div class="col"><label>City</label><input type="text" name="city" id="city"></div>
    <div class="col"><label>Area / Post Office</label><input type="text" name="area" id="area"></div>
    <div class="col"><label>Pin Code</label><input type="text" name="pincode" id="pincode" maxlength="6" onkeyup="getPincodeDetails()"></div>
  </div>

  <!-- Product Row -->
  <div class="row">
    <div class="col">
      <label>Product</label>
      <select name="product_id" id="product_id" onchange="setPrice()" required>
        <option value="">Select Product</option>
        <?php while($p=$products->fetch_assoc()){ ?>
          <option value="<?=$p['id']?>" data-price="<?=$p['price']?>"><?=$p['product_name']?> (₹<?=$p['price']?>)</option>
        <?php } ?>
      </select>
    </div>
    <div class="col"><label>Price (₹)</label><input type="number" name="price" id="price" oninput="calcTotal()" required></div>
    <div class="col"><label>Discount (₹)</label><input type="number" name="discount" id="discount" oninput="calcTotal()"></div>
    <div class="col"><label>Advance (₹)</label><input type="number" name="advance" id="advance" oninput="calcTotal()"></div>
    <div class="col"><label>Total (₹)</label><input type="number" name="total" id="total" readonly></div>
  </div>

  <!-- Remark -->
  <div class="row">
    <div class="col" style="flex:100%;">
      <label>Remark</label>
      <textarea name="remark"></textarea>
    </div>
  </div>

  <!-- Status -->
  <!-- Status -->
<div class="row" style="justify-content:center;text-align:center;">
  <div class="col" style="max-width:250px;">
    <label>Status</label>
    <select name="status" required>
      <option value="Pending">Pending</option>
      <option value="Done">Done</option>
    </select>
  </div>
</div>


  <!-- Buttons -->
  <div class="row" style="justify-content:center;">
    <button type="submit" name="save" class="save-btn">💾 Save Order</button>
    <button type="reset" class="reset-btn">🔄 Reset</button>
  </div>

</form>
</div>
</div>

<!-- Popup -->
<div class="popup" id="popup" onclick="if(event.target===this)closePopup()">
  <div class="popup-content">
    <button class="close-btn" onclick="closePopup()">✖</button>
    <h3>📜 Previous Order History</h3>
    <div id="popup-data">Loading...</div>
    <button class="view-btn" onclick="window.location='view_orders.php'">🔍 View Full History</button>
  </div>
</div>
</body>
</html>
